/* Preparation for conversion factors: this is copied from how I did it for NDNS, but adapted from the GHS 2000-1 dervied variable specifications
   METHOD: 
	1. Basically, are simply re-aggregating the DVs at a beverage-specific level and then multiplying them by the requisite amounts (i.e. table wine * 2)
	2. However, for beer and strong beer need to go back further, as applying different figures for different containers

* Do the first .do file before this so that everything is in order

/* FOR FIRST TIME THROUGH
gen drating_o = drating
gen nbunits_o = nbunits
gen sbunits_o = sbunits
gen wineq_o = wineq
*/


******************************************************************************************************************************************************
* THIS SETS THE CONVERSION FACTORS FROM REPORTED VOLUMES TO CONSUMPTION

* ORIGINAL CONVERSION FACTORS:
global nbhalfs 	= 1
global nbsmcans 	= 1
global nblgcans	= 1.5

global sbhalfs    = 1.5
global sbsmcans 	= 1.5
global sblgcans	= 2.3

global wnunits	= 1

/* NEW CONVERSION FACTORS
global nbhalfs 	= 1
global nbsmcans 	= 1.5
global nblgcans	= 2

global sbhalfs    = 2
global sbsmcans 	= 2
global sblgcans	= 3

global wnunits	= 2
*/

******************************************************************************************************************************************************

* STEP 1: CHANGING THE QUANTITY VARIABLES
capture drop caseid
sort hserial persno
gen caseid=_n
order caseid
mvdecode nbeerq1-nbeerq4 nbrpint nbunits_o sbeerq1-sbeerq4 sbrpint sbunits_o spirits spiritsq sherry sherryq ///
	wine wineq pops popsq qnbeer qsbeer qspirit qsherry qwine qpops qpops , mv(-9=. \ -8=.r \ -6=.)

/* NORMAL BEER: for this, simply need to know that (unlike NDNS) the nbeerq1-nbeer14 variables already refer to a particularly container size, which is
   1 = half pints, 2 = small cans, 3 = large cans, and 4 = bottles.
	NBRPINT var: the correspondences to make sense of this are: .44 "250ml" .48 "275ml" .58 "330ml" .77 "440ml" .88 "500ml" .97 "550ml" 1 "1 pint"	
	remembering that this was taken from detail on the brand of bottle usually bought */

capture gen nbunits
drop nbunits
gen nbunits=0			// Missing values are -8 in drinknow (n=22), -8 in drinkany (n=1) for reference
replace nbunits = nbunits + ($nbhalfs  * nbeerq1) if nbeerq1<.
replace nbunits = nbunits + ($nbsmcans * nbeerq2) if nbeerq2<.
replace nbunits = nbunits + ($nblgcans * nbeerq3) if nbeerq3<.
replace nbunits = nbunits + (nbrpint   * nbeerq4) if nbeerq4<.
replace nbunits = . if drinknow<0 | drinkany==-8 | drating_o==.		// There is one case that requires the drating_o==. (have a look in detail if needed)
replace nbunits_o = . if drinkany<0 

/* NOTE that unlike the original dataset, the sbunits field has already been adjusted for alcoholic strength	*/
capture gen sbunits
drop sbunits
gen sbunits=0			// Missing values are -8 in drinknow (n=22), -8 in drinkany (n=1) for reference
replace sbunits = sbunits + ($sbhalfs  * sbeerq1) if sbeerq1<.
replace sbunits = sbunits + ($sbsmcans * sbeerq2) if sbeerq2<.
replace sbunits = sbunits + ($sblgcans * sbeerq3) if sbeerq3<.
replace sbunits = sbunits + (sbrpint*1.5* sbeerq4) if sbeerq4<.
replace sbunits = . if drinknow<0 | drinkany==-8 | drating_o==.		// See above under nbeer for reason for included third part of this
replace sbunits_o = . if drinkany<0 

replace wineq = wineq_o * $wnunits if wineq_o>0


******************************************************************************************************************************************************

* STEP 2: COMBINING QUANTITY VARIABLES INTO OVERALL CONSUMPTION
capture drop _nbeer _sbeer _spirits _sherry _wine _pops 
recode nbeer sbeer spirits sherry wine pops (1=7) (2=5.5) (3=3.5) (4=1.5) (5=0.375) (6=0.115) (7=0.029) (8=0), ///
	 gen (_nbeer _sbeer _spirits _sherry _wine _pops)

capture drop _qnbeer-_qpops
gen double _qnbeer 	= nbunits*_nbeer if _nbeer<.
replace _qnbeer = 0 if _qnbeer >= . & schedtyp==1 & drinknow>0 & drinkany~=-8
gen double _qsbeer 	= sbunits*_sbeer if _sbeer<.
replace _qsbeer = 0 if _qsbeer >= . & schedtyp==1 & drinknow>0 & drinkany~=-8
gen double _qspirit	= spiritsq*_spirits if _spirits<.
replace _qspirit = 0 if _qspirit >= . & schedtyp==1 & drinknow>0 & drinkany~=-8
gen double _qsherry	= sherryq*_sherry if _sherry<.
replace _qsherry = 0 if _qsherry >= . & schedtyp==1 & drinknow>0 & drinkany~=-8
gen double _qwine		= wineq*_wine if _wine<. 
replace _qwine= 0 if _qwine >= . & schedtyp==1 & drinknow>0 & drinkany~=-8
gen double _qpops		= 1.5 * qpops*_pops if _pops<. 
replace _qpops = 0 if _qpops >= . & schedtyp==1 & drinknow>0 & drinkany~=-8

capture drop drating_i
gen double drating_i=0
foreach var of varlist _qnbeer-_qpops	{
							replace drating_i 	= drating_i + `var' if `var'<.
							}
replace drating_i=. if drating_o==.


